/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.gui;

import com.wuest.prefab.Tuple;
import com.wuest.prefab.events.ClientEventHandler;
import com.wuest.prefab.gui.GuiLangKeys;
import com.wuest.prefab.gui.GuiUtils;
import com.wuest.prefab.structures.base.EnumStairsMaterial;
import com.wuest.prefab.structures.base.EnumStructureMaterial;
import com.wuest.prefab.structures.config.StructurePartConfiguration;
import com.wuest.prefab.structures.gui.GuiStructure;
import com.wuest.prefab.structures.messages.StructureTagMessage;
import com.wuest.prefab.structures.predefined.StructurePart;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiSlider;

public class GuiStructurePart
extends GuiStructure {
    protected StructurePartConfiguration configuration;
    protected GuiSlider sldrStairWidth;
    protected GuiSlider sldrStairHeight;
    protected GuiSlider sldrGeneralWidth;
    protected GuiSlider sldrGeneralHeight;
    protected GuiButtonExt btnPartStyle;
    protected GuiButtonExt btnMaterialType;
    protected GuiButtonExt btnStairsMaterialType;

    public GuiStructurePart() {
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.Parts;
    }

    @Override
    protected void Initialize() {
        this.modifiedInitialXAxis = 212;
        this.modifiedInitialYAxis = 117;
        this.shownImageHeight = 150;
        this.shownImageWidth = 268;
        this.configuration = ClientEventHandler.playerConfig.getClientConfig("Parts", StructurePartConfiguration.class);
        this.configuration.pos = this.pos;
        this.structureImageLocation = this.configuration.style.getPictureLocation();
        Tuple<Integer, Integer> adjustedValue = this.getAdjustedXYValue();
        int grayBoxX = adjustedValue.getFirst();
        int grayBoxY = adjustedValue.getSecond();
        this.btnPartStyle = this.createAndAddButton(8, grayBoxX + 15, grayBoxY + 40, 90, 20, this.configuration.style.translateKey);
        this.btnMaterialType = this.createAndAddButton(9, grayBoxX + 15, grayBoxY + 75, 90, 20, this.configuration.partMaterial.getTranslatedName(), false);
        this.btnStairsMaterialType = this.createAndAddButton(10, grayBoxX + 15, grayBoxY + 75, 90, 20, this.configuration.stairsMaterial.getTranslatedName(), false);
        this.sldrStairHeight = this.createAndAddSlider(4, grayBoxX + 15, grayBoxY + 110, 90, 20, "", "", 1.0, 9.0, this.configuration.stairHeight, false, true);
        this.sldrStairWidth = this.createAndAddSlider(5, grayBoxX + 15, grayBoxY + 145, 90, 20, "", "", 1.0, 9.0, this.configuration.stairWidth, false, true);
        this.sldrGeneralHeight = this.createAndAddSlider(6, grayBoxX + 15, grayBoxY + 110, 90, 20, "", "", 3.0, 9.0, this.configuration.generalHeight, false, true);
        this.sldrGeneralWidth = this.createAndAddSlider(7, grayBoxX + 15, grayBoxY + 145, 90, 20, "", "", 3.0, 9.0, this.configuration.generalWidth, false, true);
        this.btnVisualize = this.createAndAddCustomButton(3, grayBoxX + 25, grayBoxY + 175, 90, 20, "prefab.gui.button.preview");
        this.btnBuild = this.createAndAddCustomButton(1, grayBoxX + 310, grayBoxY + 175, 90, 20, "prefab.gui.button.build");
        this.btnCancel = this.createAndAddButton(2, grayBoxX + 150, grayBoxY + 175, 90, 20, "prefab.gui.button.cancel");
    }

    @Override
    protected void preButtonRender(int x, int y, int mouseX, int mouseY, float partialTicks) {
        int imagePanelUpperLeft = x + 132;
        int imagePanelWidth = 285;
        int imagePanelMiddle = imagePanelWidth / 2;
        this.func_146276_q_();
        this.drawControlLeftPanel(x + 10, y + 10, 125, 190);
        this.drawControlRightPanel(imagePanelUpperLeft, y + 10, imagePanelWidth, 190);
        int middleOfImage = this.shownImageWidth / 2;
        int imageLocation = imagePanelUpperLeft + (imagePanelMiddle - middleOfImage);
        GuiUtils.bindTexture(this.structureImageLocation);
        Gui.func_152125_a((int)imageLocation, (int)(y + 15), (float)0.0f, (float)0.0f, (int)this.shownImageWidth, (int)this.shownImageHeight, (int)this.shownImageWidth, (int)this.shownImageHeight, (float)this.shownImageWidth, (float)this.shownImageHeight);
    }

    @Override
    protected void postButtonRender(int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.drawString(GuiLangKeys.translateString("item.prefab:item_structure_part.name"), x + 15, y + 17, this.textColor);
        this.drawString(GuiLangKeys.translateString("prefab.gui.style"), x + 15, y + 30, this.textColor);
        this.drawString(GuiLangKeys.translateString("prefab.gui.material"), x + 15, y + 65, this.textColor);
        if (this.configuration.style == StructurePartConfiguration.EnumStyle.Stairs || this.configuration.style == StructurePartConfiguration.EnumStyle.Roof) {
            this.sldrStairHeight.field_146125_m = this.configuration.style != StructurePartConfiguration.EnumStyle.Roof;
            this.sldrStairWidth.field_146125_m = true;
            this.sldrGeneralHeight.field_146125_m = false;
            this.sldrGeneralWidth.field_146125_m = false;
            this.btnStairsMaterialType.field_146125_m = true;
            this.btnMaterialType.field_146125_m = false;
        } else {
            this.btnStairsMaterialType.field_146125_m = false;
            this.btnMaterialType.field_146125_m = true;
            this.sldrStairHeight.field_146125_m = false;
            this.sldrStairWidth.field_146125_m = false;
            this.sldrGeneralHeight.field_146125_m = true;
            this.sldrGeneralWidth.field_146125_m = true;
        }
        if (this.configuration.style != StructurePartConfiguration.EnumStyle.Roof) {
            if (this.configuration.style == StructurePartConfiguration.EnumStyle.Floor) {
                this.drawString(GuiLangKeys.translateString("prefab.gui.length"), x + 15, y + 100, this.textColor);
            } else {
                this.drawString(GuiLangKeys.translateString("prefab.gui.height"), x + 15, y + 100, this.textColor);
            }
        }
        this.drawString(GuiLangKeys.translateString("prefab.gui.width"), x + 15, y + 135, this.textColor);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        this.configuration.houseFacing = Minecraft.func_71410_x().field_71439_g.func_174811_aO().func_176734_d();
        this.configuration.stairHeight = this.sldrStairHeight.getValueInt();
        this.configuration.stairWidth = this.sldrStairWidth.getValueInt();
        this.configuration.generalHeight = this.sldrGeneralHeight.getValueInt();
        this.configuration.generalWidth = this.sldrGeneralWidth.getValueInt();
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.btnMaterialType) {
            this.configuration.partMaterial = EnumStructureMaterial.getMaterialByNumber(this.configuration.partMaterial.getNumber() + 1);
            this.btnMaterialType.field_146126_j = this.configuration.partMaterial.getTranslatedName();
        } else if (button == this.btnStairsMaterialType) {
            this.configuration.stairsMaterial = EnumStairsMaterial.getByOrdinal(this.configuration.stairsMaterial.ordinal() + 1);
            this.btnStairsMaterialType.field_146126_j = this.configuration.stairsMaterial.getTranslatedName();
        } else if (button == this.btnPartStyle) {
            this.configuration.style = StructurePartConfiguration.EnumStyle.getByOrdinal(this.configuration.style.ordinal() + 1);
            this.btnPartStyle.field_146126_j = GuiLangKeys.translateString(this.configuration.style.translateKey);
            this.structureImageLocation = this.configuration.style.getPictureLocation();
        } else if (button == this.btnVisualize) {
            StructurePart structure = new StructurePart();
            structure.getClearSpace().getShape().setDirection(EnumFacing.NORTH);
            structure.setupStructure((World)this.field_146297_k.field_71441_e, this.configuration, this.pos);
            this.performPreview(structure, this.configuration);
        }
    }
}

